/**
* \file: message_sender.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_APP_IFACE_MESSAGE_SENDER_H
#define AAM_APP_IFACE_MESSAGE_SENDER_H

#include "automounter_types.h"
#include "app_iface/app_iface_extern.h"
#include "ipc/info_messages.h"

void message_sender_send_request_done_msg(app_iface_request_ctx_t *request_ctx, error_code_t result,
		const char *error_msg);

void message_sender_send_partition_event_msg(info_event_t event,
		const device_info_t *dev_info, const partition_info_t *part_info);

void message_sender_send_device_event_msg(info_event_t event, const device_info_t *dev_info);

error_code_t message_sender_send_snapshot_done_msg(connection_ctx_t *ctx, int request_id);

error_code_t message_sender_send_device_update_msg(connection_ctx_t *ctx, const device_info_t *dev_info,int request_id);

error_code_t message_sender_send_partition_update_msg(connection_ctx_t *ctx, const device_info_t *dev_info,
		const partition_info_t *part_info, int request_id);

#endif
